package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Connection {

  def apply(
    internalResourceId: String,
    authorization: software.amazon.awscdk.services.events.Authorization,
    connectionName: Option[String] = None,
    description: Option[String] = None,
    headerParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None,
    queryStringParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None,
    bodyParameters: Option[Map[String, _ <: software.amazon.awscdk.services.events.HttpParameter]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.events.Connection =
    software.amazon.awscdk.services.events.Connection.Builder
      .create(stackCtx, internalResourceId)
      .authorization(authorization)
      .connectionName(connectionName.orNull)
      .description(description.orNull)
      .headerParameters(headerParameters.map(_.asJava).orNull)
      .queryStringParameters(queryStringParameters.map(_.asJava).orNull)
      .bodyParameters(bodyParameters.map(_.asJava).orNull)
      .build()
}
