package io.burkard.cdk.services.ecs.cfnTaskDefinition

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TmpfsProperty {

  def apply(
    size: Number,
    containerPath: Option[String] = None,
    mountOptions: Option[List[String]] = None
  ): software.amazon.awscdk.services.ecs.CfnTaskDefinition.TmpfsProperty =
    (new software.amazon.awscdk.services.ecs.CfnTaskDefinition.TmpfsProperty.Builder)
      .size(size)
      .containerPath(containerPath.orNull)
      .mountOptions(mountOptions.map(_.asJava).orNull)
      .build()
}
