package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EcsTarget {

  def apply(
    containerName: String,
    newTargetGroupId: String,
    listener: software.amazon.awscdk.services.ecs.ListenerConfig,
    containerPort: Option[Number] = None,
    protocol: Option[software.amazon.awscdk.services.ecs.Protocol] = None
  ): software.amazon.awscdk.services.ecs.EcsTarget =
    (new software.amazon.awscdk.services.ecs.EcsTarget.Builder)
      .containerName(containerName)
      .newTargetGroupId(newTargetGroupId)
      .listener(listener)
      .containerPort(containerPort.orNull)
      .protocol(protocol.orNull)
      .build()
}
