package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTrafficMirrorTarget {

  def apply(
    internalResourceId: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    gatewayLoadBalancerEndpointId: Option[String] = None,
    networkLoadBalancerArn: Option[String] = None,
    networkInterfaceId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnTrafficMirrorTarget =
    software.amazon.awscdk.services.ec2.CfnTrafficMirrorTarget.Builder
      .create(stackCtx, internalResourceId)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .gatewayLoadBalancerEndpointId(gatewayLoadBalancerEndpointId.orNull)
      .networkLoadBalancerArn(networkLoadBalancerArn.orNull)
      .networkInterfaceId(networkInterfaceId.orNull)
      .build()
}
