package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnKeyPairProps {

  def apply(
    keyName: String,
    keyType: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    publicKeyMaterial: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnKeyPairProps =
    (new software.amazon.awscdk.services.ec2.CfnKeyPairProps.Builder)
      .keyName(keyName)
      .keyType(keyType.orNull)
      .tags(tags.map(_.asJava).orNull)
      .publicKeyMaterial(publicKeyMaterial.orNull)
      .build()
}
