package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHost {

  def apply(
    internalResourceId: String,
    instanceType: String,
    availabilityZone: String,
    hostRecovery: Option[String] = None,
    autoPlacement: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnHost =
    software.amazon.awscdk.services.ec2.CfnHost.Builder
      .create(stackCtx, internalResourceId)
      .instanceType(instanceType)
      .availabilityZone(availabilityZone)
      .hostRecovery(hostRecovery.orNull)
      .autoPlacement(autoPlacement.orNull)
      .build()
}
