package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClientVpnRouteProps {

  def apply(
    clientVpnEndpointId: String,
    destinationCidrBlock: String,
    targetVpcSubnetId: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnClientVpnRouteProps =
    (new software.amazon.awscdk.services.ec2.CfnClientVpnRouteProps.Builder)
      .clientVpnEndpointId(clientVpnEndpointId)
      .destinationCidrBlock(destinationCidrBlock)
      .targetVpcSubnetId(targetVpcSubnetId)
      .description(description.orNull)
      .build()
}
