package io.burkard.cdk.services.datasync.cfnTask

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OptionsProperty {

  def apply(
    posixPermissions: Option[String] = None,
    gid: Option[String] = None,
    preserveDevices: Option[String] = None,
    bytesPerSecond: Option[Number] = None,
    securityDescriptorCopyFlags: Option[String] = None,
    preserveDeletedFiles: Option[String] = None,
    mtime: Option[String] = None,
    taskQueueing: Option[String] = None,
    verifyMode: Option[String] = None,
    uid: Option[String] = None,
    transferMode: Option[String] = None,
    overwriteMode: Option[String] = None,
    atime: Option[String] = None,
    objectTags: Option[String] = None,
    logLevel: Option[String] = None
  ): software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty =
    (new software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty.Builder)
      .posixPermissions(posixPermissions.orNull)
      .gid(gid.orNull)
      .preserveDevices(preserveDevices.orNull)
      .bytesPerSecond(bytesPerSecond.orNull)
      .securityDescriptorCopyFlags(securityDescriptorCopyFlags.orNull)
      .preserveDeletedFiles(preserveDeletedFiles.orNull)
      .mtime(mtime.orNull)
      .taskQueueing(taskQueueing.orNull)
      .verifyMode(verifyMode.orNull)
      .uid(uid.orNull)
      .transferMode(transferMode.orNull)
      .overwriteMode(overwriteMode.orNull)
      .atime(atime.orNull)
      .objectTags(objectTags.orNull)
      .logLevel(logLevel.orNull)
      .build()
}
