package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxOpenZFS {

  def apply(
    internalResourceId: String,
    securityGroupArns: List[String],
    fsxFilesystemArn: String,
    protocol: software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFS.ProtocolProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subdirectory: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFS =
    software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFS.Builder
      .create(stackCtx, internalResourceId)
      .securityGroupArns(securityGroupArns.asJava)
      .fsxFilesystemArn(fsxFilesystemArn)
      .protocol(protocol)
      .tags(tags.map(_.asJava).orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
