package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserPool {

  def apply(
    internalResourceId: String,
    autoVerify: Option[software.amazon.awscdk.services.cognito.AutoVerifiedAttrs] = None,
    email: Option[software.amazon.awscdk.services.cognito.UserPoolEmail] = None,
    userVerification: Option[software.amazon.awscdk.services.cognito.UserVerificationConfig] = None,
    customSenderKmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    passwordPolicy: Option[software.amazon.awscdk.services.cognito.PasswordPolicy] = None,
    mfaMessage: Option[String] = None,
    standardAttributes: Option[software.amazon.awscdk.services.cognito.StandardAttributes] = None,
    mfaSecondFactor: Option[software.amazon.awscdk.services.cognito.MfaSecondFactor] = None,
    enableSmsRole: Option[Boolean] = None,
    signInCaseSensitive: Option[Boolean] = None,
    accountRecovery: Option[software.amazon.awscdk.services.cognito.AccountRecovery] = None,
    smsRoleExternalId: Option[String] = None,
    mfa: Option[software.amazon.awscdk.services.cognito.Mfa] = None,
    snsRegion: Option[String] = None,
    smsRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    customAttributes: Option[Map[String, _ <: software.amazon.awscdk.services.cognito.ICustomAttribute]] = None,
    userInvitation: Option[software.amazon.awscdk.services.cognito.UserInvitationConfig] = None,
    userPoolName: Option[String] = None,
    signInAliases: Option[software.amazon.awscdk.services.cognito.SignInAliases] = None,
    lambdaTriggers: Option[software.amazon.awscdk.services.cognito.UserPoolTriggers] = None,
    deviceTracking: Option[software.amazon.awscdk.services.cognito.DeviceTracking] = None,
    selfSignUpEnabled: Option[Boolean] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cognito.UserPool =
    software.amazon.awscdk.services.cognito.UserPool.Builder
      .create(stackCtx, internalResourceId)
      .autoVerify(autoVerify.orNull)
      .email(email.orNull)
      .userVerification(userVerification.orNull)
      .customSenderKmsKey(customSenderKmsKey.orNull)
      .passwordPolicy(passwordPolicy.orNull)
      .mfaMessage(mfaMessage.orNull)
      .standardAttributes(standardAttributes.orNull)
      .mfaSecondFactor(mfaSecondFactor.orNull)
      .enableSmsRole(enableSmsRole.map(Boolean.box).orNull)
      .signInCaseSensitive(signInCaseSensitive.map(Boolean.box).orNull)
      .accountRecovery(accountRecovery.orNull)
      .smsRoleExternalId(smsRoleExternalId.orNull)
      .mfa(mfa.orNull)
      .snsRegion(snsRegion.orNull)
      .smsRole(smsRole.orNull)
      .customAttributes(customAttributes.map(_.asJava).orNull)
      .userInvitation(userInvitation.orNull)
      .userPoolName(userPoolName.orNull)
      .signInAliases(signInAliases.orNull)
      .lambdaTriggers(lambdaTriggers.orNull)
      .deviceTracking(deviceTracking.orNull)
      .selfSignUpEnabled(selfSignUpEnabled.map(Boolean.box).orNull)
      .removalPolicy(removalPolicy.orNull)
      .build()
}
