package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserPoolUICustomizationAttachment {

  def apply(
    internalResourceId: String,
    clientId: String,
    userPoolId: String,
    css: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cognito.CfnUserPoolUICustomizationAttachment =
    software.amazon.awscdk.services.cognito.CfnUserPoolUICustomizationAttachment.Builder
      .create(stackCtx, internalResourceId)
      .clientId(clientId)
      .userPoolId(userPoolId)
      .css(css.orNull)
      .build()
}
