package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserPoolClientProps {

  def apply(
    userPoolId: String,
    accessTokenValidity: Option[Number] = None,
    preventUserExistenceErrors: Option[String] = None,
    analyticsConfiguration: Option[software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty] = None,
    writeAttributes: Option[List[String]] = None,
    enableTokenRevocation: Option[Boolean] = None,
    defaultRedirectUri: Option[String] = None,
    allowedOAuthScopes: Option[List[String]] = None,
    logoutUrLs: Option[List[String]] = None,
    allowedOAuthFlows: Option[List[String]] = None,
    allowedOAuthFlowsUserPoolClient: Option[Boolean] = None,
    callbackUrLs: Option[List[String]] = None,
    clientName: Option[String] = None,
    refreshTokenValidity: Option[Number] = None,
    idTokenValidity: Option[Number] = None,
    generateSecret: Option[Boolean] = None,
    tokenValidityUnits: Option[software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty] = None,
    enablePropagateAdditionalUserContextData: Option[Boolean] = None,
    readAttributes: Option[List[String]] = None,
    explicitAuthFlows: Option[List[String]] = None,
    supportedIdentityProviders: Option[List[String]] = None
  ): software.amazon.awscdk.services.cognito.CfnUserPoolClientProps =
    (new software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder)
      .userPoolId(userPoolId)
      .accessTokenValidity(accessTokenValidity.orNull)
      .preventUserExistenceErrors(preventUserExistenceErrors.orNull)
      .analyticsConfiguration(analyticsConfiguration.orNull)
      .writeAttributes(writeAttributes.map(_.asJava).orNull)
      .enableTokenRevocation(enableTokenRevocation.map(Boolean.box).orNull)
      .defaultRedirectUri(defaultRedirectUri.orNull)
      .allowedOAuthScopes(allowedOAuthScopes.map(_.asJava).orNull)
      .logoutUrLs(logoutUrLs.map(_.asJava).orNull)
      .allowedOAuthFlows(allowedOAuthFlows.map(_.asJava).orNull)
      .allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient.map(Boolean.box).orNull)
      .callbackUrLs(callbackUrLs.map(_.asJava).orNull)
      .clientName(clientName.orNull)
      .refreshTokenValidity(refreshTokenValidity.orNull)
      .idTokenValidity(idTokenValidity.orNull)
      .generateSecret(generateSecret.map(Boolean.box).orNull)
      .tokenValidityUnits(tokenValidityUnits.orNull)
      .enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData.map(Boolean.box).orNull)
      .readAttributes(readAttributes.map(_.asJava).orNull)
      .explicitAuthFlows(explicitAuthFlows.map(_.asJava).orNull)
      .supportedIdentityProviders(supportedIdentityProviders.map(_.asJava).orNull)
      .build()
}
