package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserPool {

  def apply(
    internalResourceId: String,
    aliasAttributes: Option[List[String]] = None,
    smsConfiguration: Option[software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty] = None,
    accountRecoverySetting: Option[software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty] = None,
    smsVerificationMessage: Option[String] = None,
    userPoolAddOns: Option[software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty] = None,
    emailVerificationMessage: Option[String] = None,
    deviceConfiguration: Option[software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty] = None,
    smsAuthenticationMessage: Option[String] = None,
    autoVerifiedAttributes: Option[List[String]] = None,
    usernameAttributes: Option[List[String]] = None,
    userPoolTags: Option[AnyRef] = None,
    enabledMfas: Option[List[String]] = None,
    schema: Option[List[_]] = None,
    usernameConfiguration: Option[software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty] = None,
    emailVerificationSubject: Option[String] = None,
    mfaConfiguration: Option[String] = None,
    verificationMessageTemplate: Option[software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty] = None,
    adminCreateUserConfig: Option[software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty] = None,
    userPoolName: Option[String] = None,
    emailConfiguration: Option[software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty] = None,
    lambdaConfig: Option[software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty] = None,
    userAttributeUpdateSettings: Option[software.amazon.awscdk.services.cognito.CfnUserPool.UserAttributeUpdateSettingsProperty] = None,
    policies: Option[software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cognito.CfnUserPool =
    software.amazon.awscdk.services.cognito.CfnUserPool.Builder
      .create(stackCtx, internalResourceId)
      .aliasAttributes(aliasAttributes.map(_.asJava).orNull)
      .smsConfiguration(smsConfiguration.orNull)
      .accountRecoverySetting(accountRecoverySetting.orNull)
      .smsVerificationMessage(smsVerificationMessage.orNull)
      .userPoolAddOns(userPoolAddOns.orNull)
      .emailVerificationMessage(emailVerificationMessage.orNull)
      .deviceConfiguration(deviceConfiguration.orNull)
      .smsAuthenticationMessage(smsAuthenticationMessage.orNull)
      .autoVerifiedAttributes(autoVerifiedAttributes.map(_.asJava).orNull)
      .usernameAttributes(usernameAttributes.map(_.asJava).orNull)
      .userPoolTags(userPoolTags.orNull)
      .enabledMfas(enabledMfas.map(_.asJava).orNull)
      .schema(schema.map(_.asJava).orNull)
      .usernameConfiguration(usernameConfiguration.orNull)
      .emailVerificationSubject(emailVerificationSubject.orNull)
      .mfaConfiguration(mfaConfiguration.orNull)
      .verificationMessageTemplate(verificationMessageTemplate.orNull)
      .adminCreateUserConfig(adminCreateUserConfig.orNull)
      .userPoolName(userPoolName.orNull)
      .emailConfiguration(emailConfiguration.orNull)
      .lambdaConfig(lambdaConfig.orNull)
      .userAttributeUpdateSettings(userAttributeUpdateSettings.orNull)
      .policies(policies.orNull)
      .build()
}
