package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthFlow {

  def apply(
    adminUserPassword: Option[Boolean] = None,
    userPassword: Option[Boolean] = None,
    userSrp: Option[Boolean] = None,
    custom: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.AuthFlow =
    (new software.amazon.awscdk.services.cognito.AuthFlow.Builder)
      .adminUserPassword(adminUserPassword.map(Boolean.box).orNull)
      .userPassword(userPassword.map(Boolean.box).orNull)
      .userSrp(userSrp.map(Boolean.box).orNull)
      .custom(custom.map(Boolean.box).orNull)
      .build()
}
