package io.burkard.cdk.services.codebuild

sealed abstract class ReportGroupType(val underlying: software.amazon.awscdk.services.codebuild.ReportGroupType)
  extends Product
    with Serializable

object ReportGroupType {
  implicit def toAws(value: ReportGroupType): software.amazon.awscdk.services.codebuild.ReportGroupType =
    Option(value).map(_.underlying).orNull

  case object Test
    extends ReportGroupType(software.amazon.awscdk.services.codebuild.ReportGroupType.TEST)

  case object CodeCoverage
    extends ReportGroupType(software.amazon.awscdk.services.codebuild.ReportGroupType.CODE_COVERAGE)
}
