package io.burkard.cdk.services.cloudwatch.actions

sealed abstract class OpsItemSeverity(val underlying: software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity)
  extends Product
    with Serializable

object OpsItemSeverity {
  implicit def toAws(value: OpsItemSeverity): software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity =
    Option(value).map(_.underlying).orNull

  case object Critical
    extends OpsItemSeverity(software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity.CRITICAL)

  case object High
    extends OpsItemSeverity(software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity.HIGH)

  case object Medium
    extends OpsItemSeverity(software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity.MEDIUM)

  case object Low
    extends OpsItemSeverity(software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity.LOW)
}
