package io.burkard.cdk.services.billingconductor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPricingRule {

  def apply(
    internalResourceId: String,
    modifierPercentage: Number,
    name: String,
    scope: String,
    `type`: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    service: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.billingconductor.CfnPricingRule =
    software.amazon.awscdk.services.billingconductor.CfnPricingRule.Builder
      .create(stackCtx, internalResourceId)
      .modifierPercentage(modifierPercentage)
      .name(name)
      .scope(scope)
      .`type`(`type`)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .service(service.orNull)
      .build()
}
