package io.burkard.cdk.services.billingconductor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomLineItemProps {

  def apply(
    name: String,
    billingGroupArn: String,
    customLineItemChargeDetails: Option[software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    billingPeriodRange: Option[software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty] = None
  ): software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps =
    (new software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps.Builder)
      .name(name)
      .billingGroupArn(billingGroupArn)
      .customLineItemChargeDetails(customLineItemChargeDetails.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .billingPeriodRange(billingPeriodRange.orNull)
      .build()
}
