package io.burkard.cdk.services.batch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnComputeEnvironment {

  def apply(
    internalResourceId: String,
    `type`: String,
    state: Option[String] = None,
    serviceRole: Option[String] = None,
    computeEnvironmentName: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    computeResources: Option[software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty] = None,
    unmanagedvCpus: Option[Number] = None,
    replaceComputeEnvironment: Option[Boolean] = None,
    updatePolicy: Option[software.amazon.awscdk.services.batch.CfnComputeEnvironment.UpdatePolicyProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.batch.CfnComputeEnvironment =
    software.amazon.awscdk.services.batch.CfnComputeEnvironment.Builder
      .create(stackCtx, internalResourceId)
      .`type`(`type`)
      .state(state.orNull)
      .serviceRole(serviceRole.orNull)
      .computeEnvironmentName(computeEnvironmentName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .computeResources(computeResources.orNull)
      .unmanagedvCpus(unmanagedvCpus.orNull)
      .replaceComputeEnvironment(replaceComputeEnvironment.map(Boolean.box).orNull)
      .updatePolicy(updatePolicy.orNull)
      .build()
}
