package io.burkard.cdk.services.autoscaling

sealed abstract class SpotAllocationStrategy(val underlying: software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy)
  extends Product
    with Serializable

object SpotAllocationStrategy {
  implicit def toAws(value: SpotAllocationStrategy): software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy =
    Option(value).map(_.underlying).orNull

  case object LowestPrice
    extends SpotAllocationStrategy(software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy.LOWEST_PRICE)

  case object CapacityOptimized
    extends SpotAllocationStrategy(software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy.CAPACITY_OPTIMIZED)

  case object CapacityOptimizedPrioritized
    extends SpotAllocationStrategy(software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED)
}
