package io.burkard.cdk.services.autoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MixedInstancesPolicy {

  def apply(
    launchTemplate: software.amazon.awscdk.services.ec2.ILaunchTemplate,
    instancesDistribution: Option[software.amazon.awscdk.services.autoscaling.InstancesDistribution] = None,
    launchTemplateOverrides: Option[List[_ <: software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides]] = None
  ): software.amazon.awscdk.services.autoscaling.MixedInstancesPolicy =
    (new software.amazon.awscdk.services.autoscaling.MixedInstancesPolicy.Builder)
      .launchTemplate(launchTemplate)
      .instancesDistribution(instancesDistribution.orNull)
      .launchTemplateOverrides(launchTemplateOverrides.map(_.asJava).orNull)
      .build()
}
