package io.burkard.cdk.services.athena

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkGroup {

  def apply(
    internalResourceId: String,
    name: String,
    state: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    workGroupConfiguration: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty] = None,
    recursiveDeleteOption: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.athena.CfnWorkGroup =
    software.amazon.awscdk.services.athena.CfnWorkGroup.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .state(state.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .workGroupConfiguration(workGroupConfiguration.orNull)
      .recursiveDeleteOption(recursiveDeleteOption.map(Boolean.box).orNull)
      .build()
}
