package io.burkard.cdk.services.apprunner

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnObservabilityConfiguration {

  def apply(
    internalResourceId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    observabilityConfigurationName: Option[String] = None,
    traceConfiguration: Option[software.amazon.awscdk.services.apprunner.CfnObservabilityConfiguration.TraceConfigurationProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apprunner.CfnObservabilityConfiguration =
    software.amazon.awscdk.services.apprunner.CfnObservabilityConfiguration.Builder
      .create(stackCtx, internalResourceId)
      .tags(tags.map(_.asJava).orNull)
      .observabilityConfigurationName(observabilityConfigurationName.orNull)
      .traceConfiguration(traceConfiguration.orNull)
      .build()
}
