package io.burkard.cdk.services.apigateway.cfnDeployment

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DeploymentCanarySettingsProperty {

  def apply(
    useStageCache: Option[Boolean] = None,
    percentTraffic: Option[Number] = None,
    stageVariableOverrides: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty =
    (new software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty.Builder)
      .useStageCache(useStageCache.map(Boolean.box).orNull)
      .percentTraffic(percentTraffic.orNull)
      .stageVariableOverrides(stageVariableOverrides.map(_.asJava).orNull)
      .build()
}
