package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CopyOptions {

  def apply(
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    exclude: Option[List[String]] = None,
    follow: Option[software.amazon.awscdk.SymlinkFollowMode] = None
  ): software.amazon.awscdk.CopyOptions =
    (new software.amazon.awscdk.CopyOptions.Builder)
      .ignoreMode(ignoreMode.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .follow(follow.orNull)
      .build()
}
