package io.burkard.cdk.services.sns.subscriptions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SmsSubscription {

  def apply(
    phoneNumber: String,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.sns.subscriptions.SmsSubscription =
    software.amazon.awscdk.services.sns.subscriptions.SmsSubscription.Builder
      .create(phoneNumber)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
