package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServerlessClusterFromSnapshot {

  def apply(
    internalResourceId: String,
    snapshotIdentifier: String,
    engine: software.amazon.awscdk.services.rds.IClusterEngine,
    subnetGroup: Option[software.amazon.awscdk.services.rds.ISubnetGroup] = None,
    backupRetention: Option[software.amazon.awscdk.Duration] = None,
    enableDataApi: Option[Boolean] = None,
    defaultDatabaseName: Option[String] = None,
    clusterIdentifier: Option[String] = None,
    scaling: Option[software.amazon.awscdk.services.rds.ServerlessScalingOptions] = None,
    parameterGroup: Option[software.amazon.awscdk.services.rds.IParameterGroup] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    deletionProtection: Option[Boolean] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    credentials: Option[software.amazon.awscdk.services.rds.SnapshotCredentials] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot =
    software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot.Builder
      .create(stackCtx, internalResourceId)
      .snapshotIdentifier(snapshotIdentifier)
      .engine(engine)
      .subnetGroup(subnetGroup.orNull)
      .backupRetention(backupRetention.orNull)
      .enableDataApi(enableDataApi.map(Boolean.box).orNull)
      .defaultDatabaseName(defaultDatabaseName.orNull)
      .clusterIdentifier(clusterIdentifier.orNull)
      .scaling(scaling.orNull)
      .parameterGroup(parameterGroup.orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .deletionProtection(deletionProtection.map(Boolean.box).orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .vpc(vpc.orNull)
      .removalPolicy(removalPolicy.orNull)
      .credentials(credentials.orNull)
      .build()
}
