package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClusterProps {

  def apply(
    kafkaVersion: String,
    brokerNodeGroupInfo: software.amazon.awscdk.services.msk.CfnCluster.BrokerNodeGroupInfoProperty,
    numberOfBrokerNodes: Number,
    clusterName: String,
    configurationInfo: Option[software.amazon.awscdk.services.msk.CfnCluster.ConfigurationInfoProperty] = None,
    tags: Option[Map[String, String]] = None,
    enhancedMonitoring: Option[String] = None,
    clientAuthentication: Option[software.amazon.awscdk.services.msk.CfnCluster.ClientAuthenticationProperty] = None,
    openMonitoring: Option[software.amazon.awscdk.services.msk.CfnCluster.OpenMonitoringProperty] = None,
    encryptionInfo: Option[software.amazon.awscdk.services.msk.CfnCluster.EncryptionInfoProperty] = None,
    currentVersion: Option[String] = None,
    loggingInfo: Option[software.amazon.awscdk.services.msk.CfnCluster.LoggingInfoProperty] = None
  ): software.amazon.awscdk.services.msk.CfnClusterProps =
    (new software.amazon.awscdk.services.msk.CfnClusterProps.Builder)
      .kafkaVersion(kafkaVersion)
      .brokerNodeGroupInfo(brokerNodeGroupInfo)
      .numberOfBrokerNodes(numberOfBrokerNodes)
      .clusterName(clusterName)
      .configurationInfo(configurationInfo.orNull)
      .tags(tags.map(_.asJava).orNull)
      .enhancedMonitoring(enhancedMonitoring.orNull)
      .clientAuthentication(clientAuthentication.orNull)
      .openMonitoring(openMonitoring.orNull)
      .encryptionInfo(encryptionInfo.orNull)
      .currentVersion(currentVersion.orNull)
      .loggingInfo(loggingInfo.orNull)
      .build()
}
