package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubscriptionFilterProps {

  def apply(
    filterPattern: String,
    logGroupName: String,
    destinationArn: String,
    roleArn: Option[String] = None
  ): software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps =
    (new software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps.Builder)
      .filterPattern(filterPattern)
      .logGroupName(logGroupName)
      .destinationArn(destinationArn)
      .roleArn(roleArn.orNull)
      .build()
}
