package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRouteCalculatorProps {

  def apply(
    dataSource: String,
    calculatorName: String,
    description: Option[String] = None,
    pricingPlan: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnRouteCalculatorProps =
    (new software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder)
      .dataSource(dataSource)
      .calculatorName(calculatorName)
      .description(description.orNull)
      .pricingPlan(pricingPlan.orNull)
      .build()
}
