package io.burkard.cdk.services.kinesisanalyticsv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationReferenceDataSource {

  def apply(
    internalResourceId: String,
    referenceDataSource: software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty,
    applicationName: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationReferenceDataSource =
    software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationReferenceDataSource.Builder
      .create(stackCtx, internalResourceId)
      .referenceDataSource(referenceDataSource)
      .applicationName(applicationName)
      .build()
}
