package io.burkard.cdk.services.iot.cfnTopicRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FirehoseActionProperty {

  def apply(
    deliveryStreamName: String,
    roleArn: String,
    separator: Option[String] = None,
    batchMode: Option[Boolean] = None
  ): software.amazon.awscdk.services.iot.CfnTopicRule.FirehoseActionProperty =
    (new software.amazon.awscdk.services.iot.CfnTopicRule.FirehoseActionProperty.Builder)
      .deliveryStreamName(deliveryStreamName)
      .roleArn(roleArn)
      .separator(separator.orNull)
      .batchMode(batchMode.map(Boolean.box).orNull)
      .build()
}
