package io.burkard.cdk.services.gamelift

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBuild {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    version: Option[String] = None,
    operatingSystem: Option[String] = None,
    storageLocation: Option[software.amazon.awscdk.services.gamelift.CfnBuild.S3LocationProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.gamelift.CfnBuild =
    software.amazon.awscdk.services.gamelift.CfnBuild.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .version(version.orNull)
      .operatingSystem(operatingSystem.orNull)
      .storageLocation(storageLocation.orNull)
      .build()
}
