package io.burkard.cdk.services.fis.cfnExperimentTemplate

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ExperimentTemplateLogConfigurationProperty {

  def apply(
    logSchemaVersion: Number,
    cloudWatchLogsConfiguration: Option[AnyRef] = None,
    s3Configuration: Option[AnyRef] = None
  ): software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty =
    (new software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty.Builder)
      .logSchemaVersion(logSchemaVersion)
      .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration.orNull)
      .s3Configuration(s3Configuration.orNull)
      .build()
}
