package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubectlProviderAttributes {

  def apply(
    handlerRole: software.amazon.awscdk.services.iam.IRole,
    kubectlRoleArn: String,
    functionArn: String
  ): software.amazon.awscdk.services.eks.KubectlProviderAttributes =
    (new software.amazon.awscdk.services.eks.KubectlProviderAttributes.Builder)
      .handlerRole(handlerRole)
      .kubectlRoleArn(kubectlRoleArn)
      .functionArn(functionArn)
      .build()
}
