package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SubnetProps {

  def apply(
    cidrBlock: String,
    vpcId: String,
    availabilityZone: String,
    mapPublicIpOnLaunch: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.SubnetProps =
    (new software.amazon.awscdk.services.ec2.SubnetProps.Builder)
      .cidrBlock(cidrBlock)
      .vpcId(vpcId)
      .availabilityZone(availabilityZone)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
