package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVolume {

  def apply(
    internalResourceId: String,
    availabilityZone: String,
    size: Option[Number] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    volumeType: Option[String] = None,
    autoEnableIo: Option[Boolean] = None,
    encrypted: Option[Boolean] = None,
    outpostArn: Option[String] = None,
    iops: Option[Number] = None,
    multiAttachEnabled: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    throughput: Option[Number] = None,
    snapshotId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnVolume =
    software.amazon.awscdk.services.ec2.CfnVolume.Builder
      .create(stackCtx, internalResourceId)
      .availabilityZone(availabilityZone)
      .size(size.orNull)
      .tags(tags.map(_.asJava).orNull)
      .volumeType(volumeType.orNull)
      .autoEnableIo(autoEnableIo.map(Boolean.box).orNull)
      .encrypted(encrypted.map(Boolean.box).orNull)
      .outpostArn(outpostArn.orNull)
      .iops(iops.orNull)
      .multiAttachEnabled(multiAttachEnabled.map(Boolean.box).orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .throughput(throughput.orNull)
      .snapshotId(snapshotId.orNull)
      .build()
}
