package io.burkard.cdk.services.dynamodb.cfnGlobalTable

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CapacityAutoScalingSettingsProperty {

  def apply(
    minCapacity: Number,
    targetTrackingScalingPolicyConfiguration: software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty,
    maxCapacity: Number,
    seedCapacity: Option[Number] = None
  ): software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty =
    (new software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty.Builder)
      .minCapacity(minCapacity)
      .targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration)
      .maxCapacity(maxCapacity)
      .seedCapacity(seedCapacity.orNull)
      .build()
}
