package io.burkard.cdk.services.dms

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnReplicationSubnetGroupProps {

  def apply(
    replicationSubnetGroupDescription: String,
    subnetIds: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    replicationSubnetGroupIdentifier: Option[String] = None
  ): software.amazon.awscdk.services.dms.CfnReplicationSubnetGroupProps =
    (new software.amazon.awscdk.services.dms.CfnReplicationSubnetGroupProps.Builder)
      .replicationSubnetGroupDescription(replicationSubnetGroupDescription)
      .subnetIds(subnetIds.asJava)
      .tags(tags.map(_.asJava).orNull)
      .replicationSubnetGroupIdentifier(replicationSubnetGroupIdentifier.orNull)
      .build()
}
