package io.burkard.cdk.services.cloudwatch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CompositeAlarm {

  def apply(
    internalResourceId: String,
    alarmRule: software.amazon.awscdk.services.cloudwatch.IAlarmRule,
    compositeAlarmName: Option[String] = None,
    actionsEnabled: Option[Boolean] = None,
    alarmDescription: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudwatch.CompositeAlarm =
    software.amazon.awscdk.services.cloudwatch.CompositeAlarm.Builder
      .create(stackCtx, internalResourceId)
      .alarmRule(alarmRule)
      .compositeAlarmName(compositeAlarmName.orNull)
      .actionsEnabled(actionsEnabled.map(Boolean.box).orNull)
      .alarmDescription(alarmDescription.orNull)
      .build()
}
