package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookTypeConfig {

  def apply(
    internalResourceId: String,
    configuration: String,
    typeName: Option[String] = None,
    typeArn: Option[String] = None,
    configurationAlias: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudformation.CfnHookTypeConfig =
    software.amazon.awscdk.services.cloudformation.CfnHookTypeConfig.Builder
      .create(stackCtx, internalResourceId)
      .configuration(configuration)
      .typeName(typeName.orNull)
      .typeArn(typeArn.orNull)
      .configurationAlias(configurationAlias.orNull)
      .build()
}
