package io.burkard.cdk.services.billingconductor

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPricingRule {

  def apply(
    internalResourceId: String,
    modifierPercentage: Number,
    name: String,
    scope: String,
    `type`: String,
    description: Option[String] = None,
    service: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.billingconductor.CfnPricingRule =
    software.amazon.awscdk.services.billingconductor.CfnPricingRule.Builder
      .create(stackCtx, internalResourceId)
      .modifierPercentage(modifierPercentage)
      .name(name)
      .scope(scope)
      .`type`(`type`)
      .description(description.orNull)
      .service(service.orNull)
      .build()
}
