package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomainName {

  def apply(
    internalResourceId: String,
    domainName: String,
    certificateArn: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appsync.CfnDomainName =
    software.amazon.awscdk.services.appsync.CfnDomainName.Builder
      .create(stackCtx, internalResourceId)
      .domainName(domainName)
      .certificateArn(certificateArn)
      .description(description.orNull)
      .build()
}
