package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GatewayRouteProps {

  def apply(
    virtualGateway: software.amazon.awscdk.services.appmesh.IVirtualGateway,
    routeSpec: Option[software.amazon.awscdk.services.appmesh.GatewayRouteSpec] = None,
    gatewayRouteName: Option[String] = None
  ): software.amazon.awscdk.services.appmesh.GatewayRouteProps =
    (new software.amazon.awscdk.services.appmesh.GatewayRouteProps.Builder)
      .virtualGateway(virtualGateway)
      .routeSpec(routeSpec.orNull)
      .gatewayRouteName(gatewayRouteName.orNull)
      .build()
}
