package io.burkard.cdk.services.apigatewayv2.cfnAuthorizer

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object JWTConfigurationProperty {

  def apply(
    issuer: Option[String] = None,
    audience: Option[List[String]] = None
  ): software.amazon.awscdk.services.apigatewayv2.CfnAuthorizer.JWTConfigurationProperty =
    (new software.amazon.awscdk.services.apigatewayv2.CfnAuthorizer.JWTConfigurationProperty.Builder)
      .issuer(issuer.orNull)
      .audience(audience.map(_.asJava).orNull)
      .build()
}
