package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApiKey {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    generateDistinctId: Option[Boolean] = None,
    enabled: Option[Boolean] = None,
    customerId: Option[String] = None,
    stageKeys: Option[List[_]] = None,
    value: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.CfnApiKey =
    software.amazon.awscdk.services.apigateway.CfnApiKey.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .generateDistinctId(generateDistinctId.map(Boolean.box).orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .customerId(customerId.orNull)
      .stageKeys(stageKeys.map(_.asJava).orNull)
      .value(value.orNull)
      .build()
}
