package io.burkard.cdk.services.acmpca.cfnCertificateAuthority

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KeyUsageProperty {

  def apply(
    keyAgreement: Option[Boolean] = None,
    nonRepudiation: Option[Boolean] = None,
    decipherOnly: Option[Boolean] = None,
    digitalSignature: Option[Boolean] = None,
    encipherOnly: Option[Boolean] = None,
    keyEncipherment: Option[Boolean] = None,
    crlSign: Option[Boolean] = None,
    keyCertSign: Option[Boolean] = None,
    dataEncipherment: Option[Boolean] = None
  ): software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.KeyUsageProperty =
    (new software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.KeyUsageProperty.Builder)
      .keyAgreement(keyAgreement.map(Boolean.box).orNull)
      .nonRepudiation(nonRepudiation.map(Boolean.box).orNull)
      .decipherOnly(decipherOnly.map(Boolean.box).orNull)
      .digitalSignature(digitalSignature.map(Boolean.box).orNull)
      .encipherOnly(encipherOnly.map(Boolean.box).orNull)
      .keyEncipherment(keyEncipherment.map(Boolean.box).orNull)
      .crlSign(crlSign.map(Boolean.box).orNull)
      .keyCertSign(keyCertSign.map(Boolean.box).orNull)
      .dataEncipherment(dataEncipherment.map(Boolean.box).orNull)
      .build()
}
