package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTrafficRouting {

  def apply(
    targetGroups: List[String],
    testTrafficRoute: software.amazon.awscdk.CfnTrafficRoute,
    prodTrafficRoute: software.amazon.awscdk.CfnTrafficRoute
  ): software.amazon.awscdk.CfnTrafficRouting =
    (new software.amazon.awscdk.CfnTrafficRouting.Builder)
      .targetGroups(targetGroups.asJava)
      .testTrafficRoute(testTrafficRoute)
      .prodTrafficRoute(prodTrafficRoute)
      .build()
}
