package io.burkard.cdk.services.sam.cfnFunction

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KinesisEventProperty {

  def apply(
    stream: String,
    startingPosition: String,
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None
  ): software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty =
    (new software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty.Builder)
      .stream(stream)
      .startingPosition(startingPosition)
      .enabled(enabled.map(Boolean.box).orNull)
      .batchSize(batchSize.orNull)
      .build()
}
