package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatasetGroupProps {

  def apply(
    name: String,
    domain: Option[String] = None,
    roleArn: Option[String] = None,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.personalize.CfnDatasetGroupProps =
    (new software.amazon.awscdk.services.personalize.CfnDatasetGroupProps.Builder)
      .name(name)
      .domain(domain.orNull)
      .roleArn(roleArn.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
